/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

  $Id: CifxConsole_NXAPI.cpp 13949 2021-02-08 11:46:52Z RMayer $:

  Description:
    Demonstrate nXAPI functions

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2021-02-08  - removed netXAPI test functions, now availabel in the "test console" program
                - updated file header to actual version
    2010-07-22  initial version

**************************************************************************************/

#include "OS_Includes.h"
#include "CifXConsole.h"
#include "netXAPI.h"

#pragma warning(push)
#pragma warning(disable: 4702)
#include <vector>
#pragma warning(pop)

/*****************************************************************************/
/*! Device struct for found device                                           */
/*****************************************************************************/
typedef struct NXAPI_FOUND_DEVICE_Ttag
{
  NXDRV_DEVICE_INFORMATION    tDeviceInfo;    /*!< Device information struct */

} NXAPI_FOUND_DEVICE_T, *PNXAPI_FOUND_DEVICE_T;

typedef std::vector<PNXAPI_FOUND_DEVICE_T> DEVICE_LIST;

/*****************************************************************************/
/*! Print device information                                                 */
/*****************************************************************************/
long PrintFindDeviceInfo(PNXDRV_DEVICE_INFORMATION ptDeviceInfo)
{
 long lRet = NXAPI_NO_ERROR;
  printf("------------------------------------------------\n");
  printf("hDevice               = 0x%08X \r\n", (unsigned long)ptDeviceInfo->hDevice               );
  printf("szDeviceName          = %s     \r\n", ptDeviceInfo->szDeviceName          );
  printf("ulDpmTotalSize        = 0x%08X \r\n", ptDeviceInfo->tSystemInfoBlock.ulDpmTotalSize    );
  printf("ulDeviceNumber        = 0x%08X \r\n", ptDeviceInfo->tSystemInfoBlock.ulDeviceNumber    );
  printf("ulSerialNumber        = 0x%08X \r\n", ptDeviceInfo->tSystemInfoBlock.ulSerialNumber    );
  printf("ausHwOptions[0]       = 0x%04X \r\n", ptDeviceInfo->tSystemInfoBlock.ausHwOptions[0]   );
  printf("ausHwOptions[1]       = 0x%04X \r\n", ptDeviceInfo->tSystemInfoBlock.ausHwOptions[1]   );
  printf("ausHwOptions[2]       = 0x%04X \r\n", ptDeviceInfo->tSystemInfoBlock.ausHwOptions[2]   );
  printf("ausHwOptions[3]       = 0x%04X \r\n", ptDeviceInfo->tSystemInfoBlock.ausHwOptions[3]   );
  printf("usManufacturer        = 0x%04X \r\n", ptDeviceInfo->tSystemInfoBlock.usManufacturer    );
  printf("usProductionDate      = 0x%04X \r\n", ptDeviceInfo->tSystemInfoBlock.usProductionDate  );
  printf("ulLicenseFlags1       = 0x%08X \r\n", ptDeviceInfo->tSystemInfoBlock.ulLicenseFlags1   );
  printf("ulLicenseFlags2       = 0x%08X \r\n", ptDeviceInfo->tSystemInfoBlock.ulLicenseFlags2   );
  printf("usNetxLicenseID       = 0x%04X \r\n", ptDeviceInfo->tSystemInfoBlock.usNetxLicenseID   );
  printf("usNetxLicenseFlags    = 0x%04X \r\n", ptDeviceInfo->tSystemInfoBlock.usNetxLicenseFlags);
  printf("usDeviceClass         = 0x%04X \r\n", ptDeviceInfo->tSystemInfoBlock.usDeviceClass     );
  printf("bHwRevision           = 0x%02X \r\n", ptDeviceInfo->tSystemInfoBlock.bHwRevision       );
  printf("bHwCompatibility      = 0x%02X \r\n", ptDeviceInfo->tSystemInfoBlock.bHwCompatibility  );
  printf("------------------------------------------------\n");
  printf("\r\n");


 return lRet;
}

//=============================================================================
// Test NXAPI Download progress callback
//
//
//=============================================================================
long APIENTRY TestnxAPIDownloadProgress(unsigned long ulStep, unsigned long ulMaxStep, void* pvUser, char bFinished, long lError)
{
  UNREFERENCED_PARAMETER(lError);
  UNREFERENCED_PARAMETER(bFinished);
  CONSOLE_SCREEN_BUFFER_INFO* csbiInfo = (CONSOLE_SCREEN_BUFFER_INFO*)pvUser;
  SetConsoleCursorPosition(GetStdHandle(STD_OUTPUT_HANDLE), csbiInfo->dwCursorPosition);

  if (ulMaxStep>0)
    printf("%3d%%", ulStep*100/ulMaxStep);

  return CIFX_NO_ERROR;
}

//=============================================================================
// Test NXAPI Connector Config
//
//
//=============================================================================
void TestConnectorConfig( char* pszBoardName )
{
  long lRet           = NXAPI_NO_ERROR;
  char abTempName[64] = {0};

  /* Open the driver and load all components */
  CIFXHANDLE hDriver;
  lRet = xDriverOpen(&hDriver);
  if( CIFX_NO_ERROR != lRet)
  {
    ShowError( lRet);
    return;
  }

  /* Initialize the nxDrvAPI() */
  nxDrvInit();
  printf("\n--- NXAPI Connector config test function ---\r\n");

  if( 0 == strlen(pszBoardName))
  {
    printf("Board name is empty!, test finished\r\n");
  }else
  {
    printf("Call nxConGetCorrespondName Name:%s Cmd: NXCON_GET_FULL_NAME \r\n",pszBoardName);
    if( NXAPI_NO_ERROR != ( lRet = nxConGetCorrespondName( pszBoardName, NXCON_GET_SHORT_NAME, sizeof(abTempName), abTempName)))
    {
      printf("- nxConGetCorrespondName returns: 0x%08X \r\n", lRet);
    }else
    {
      printf("- nxConGetCorrespondName was called Name: %s, CorrespondName: %s\r\n\n", pszBoardName, abTempName);
      printf("Call nxConGetCorrespondName Name:%s Cmd: NXCON_GET_SHORT_NAME \r\n", abTempName);
      char abTempShort[32] = {0};
      if( NXAPI_NO_ERROR != ( lRet = nxConGetCorrespondName( abTempName, NXCON_GET_FULL_NAME, sizeof(abTempShort), abTempShort)))
      {
        printf("- nxConGetCorrespondName returns: 0x%08X \r\n", lRet);
      }else
      {
        printf("- nxConGetCorrespondName was called Name: %s, CorrespondName: %s\r\n\n", abTempName, abTempShort);
      }
    }
  }

  std::vector<NXCON_CONNECTOR_INFO_T> cvConnector;

  // Test find first / find next connector
  if(CIFX_NO_ERROR == lRet)
  {
    printf("Call nxConEnumerate \r\n");

    NXCON_CONNECTOR_INFO_T tConnector = {0};

    unsigned long ulConnectorIdx = 0;
    while ( NXAPI_NO_ERROR == (lRet = nxConEnumerate(ulConnectorIdx, sizeof(tConnector), &tConnector)))
    {
      printf("\r\n");
      printf("----------------------------------------------------------------------\r\n");
      printf(" Connector Index        : %u\r\n", ulConnectorIdx);
      printf(" Connector UUID         : %s\r\n", tConnector.szConnectorUUID);
      printf(" Connector FileName:    : %s\r\n", tConnector.szFileName);
      printf(" Connector Identifier   : %s\r\n", tConnector.szIdentifier);
      printf(" Connector Type         : %u\r\n", tConnector.ulConnectorType);
      printf("\r\n");

      // Save found connector
      cvConnector.push_back(tConnector);
      ulConnectorIdx++;
    }
    // Set error state
    lRet = NXAPI_NO_ERROR;
  }

  if(NXAPI_NO_ERROR == lRet)
  {
    printf("Call nxConGetConfig\r\n");

    NXCON_CONNECTOR_INFO_T tConnector = {0};


    for(unsigned long ulConnector = 0;
        ulConnector < cvConnector.size();
        ulConnector++)
    {
      tConnector = cvConnector[ulConnector];

      char abTempConfig[1024] = {0};
      unsigned long ulSize = sizeof(abTempConfig);

      if(NXAPI_NO_ERROR == (lRet = nxConGetConfig(tConnector.szConnectorUUID, (uint32_t*)&ulSize, abTempConfig)))
      {
        printf("\r\n");
        printf(" Got Configuration of Connector: %s, Connector Identifier: %s \r\n", tConnector.szFileName, tConnector.szIdentifier);
        printf("----------------------------------------------------------------------\r\n");
        printf(" Connector Configuration: \r\n");

        printf(" %s\r\n", abTempConfig);
        printf("\r\n");
      } else
      {
        printf("- nxConGetConfig returns: lRet: 0x%08X \r\n", lRet);
      }

    }
    lRet = NXAPI_NO_ERROR;
  }

  if(NXAPI_NO_ERROR == lRet)
  {
    printf("Call nxConSetConfig \r\n");

    NXCON_CONNECTOR_INFO_T tConnector = {0};

    unsigned long ulConnector = 0;
    tConnector = cvConnector[ulConnector];

    std::string szTempConfig("DEVNAME=GLOBAL,ENABLED=0,KEEPALIVETIMEOUT=2000,RESETTIMEOUT=2000;DEVNAME=COM1,BAUDRATE=115200,BYTESIZE=8,PARITY=0,STOPBITS=0;DEVNAME=COM10,BAUDRATE=115200,BYTESIZE=8,PARITY=0,STOPBITS=0;");

    if(NXAPI_NO_ERROR == (lRet = nxConSetConfig(tConnector.szConnectorUUID, (char*) szTempConfig.c_str())))
    {
      printf("\r\n");
      printf(" Set Configuration of Connector: %s, Connector Identifier: %s \r\n", tConnector.szFileName, tConnector.szIdentifier);
      printf("----------------------------------------------------------------------\r\n");
      printf(" Connector Configuration: \r\n");
      printf(" %s\r\n", szTempConfig.c_str());
      printf("\r\n");
    } else
    {
        printf("- nxConSetConfig returns: lRet: 0x%08X \r\n", lRet);
    }

    if(NXAPI_NO_ERROR == lRet)
    {
      ulConnector++;
      tConnector = cvConnector[ulConnector];
      szTempConfig.clear();
      szTempConfig.append("DEVNAME=GLOBAL,CONNECTTIMEOUT=1000,ENABLED=1,KEEPALIVETIMEOUT=5000,RESETTIMEOUT=2000;DEVNAME=IF0,IPADDR=192.168.10.50,IPADDREND=,PORT=50111;DEVNAME=IF1,IPADDR=192.168.10.11,IPADDREND=192.168.10.13,PORT=50111;");

      if(NXAPI_NO_ERROR == (lRet = nxConSetConfig(tConnector.szConnectorUUID, (char*)szTempConfig.c_str())))
      {
        printf("\r\n");
        printf(" Set Configuration of Connector: %s, Connector Identifier: %s \r\n", tConnector.szFileName, tConnector.szIdentifier);
        printf("----------------------------------------------------------------------\r\n");
        printf(" Connector Configuration: \r\n");
        printf(" %s\r\n", szTempConfig.c_str());
        printf("\r\n");
      } else
      {
          printf("- nxConSetConfig returns: lRet: 0x%08X \r\n", lRet);
      }
    }
  }

  nxDrvExit();

  /* Unload all components */
  if (NULL != hDriver)
    xDriverClose(hDriver);
}

